Option Explicit On
Public Class MEGSV
    '*************************************************'
    '*                                               *'
    '*  VB.NET-Module for GSV-Functions in MEGSV.DLL *'
    '*  Version 1.40                                 *'
    '*                                               *'
    '*  Copyright (C) Dr. Holger Kabelitz 1999-2006  *'
    '*  All rights reserved.                         *'
    '*                                               *'
    '*  Dr. Holger Kabelitz                          *'
    '*  D-13507 Berlin                               *'
    '*  Germany                                      *'
    '*                                               *'
    '*************************************************'

    'Attribute VB_Name = "ME_GSV_API"

    Public Const GSV_OK As Long = 0
    Public Const GSV_ERROR As Long = -1
    Public Const GSV_TRUE As Long = 1
    Public Const GSV_MEMORY_OK As Byte = GSV_OK
    Public Const GSV_MEMORY_OK_FUNCTION As Byte = &H1
    Public Const GSV_MEMORY_ERROR_ABORT As Byte = &HFF
    Public Const GSV_MEMORY_ERROR_SEVERE As Byte = &H10
    Public Const GSV_MEMORY_ERROR_NA As Byte = &H11
    Public Const GSV_MEMORY_ERROR_DATA As Byte = &H12
    Public Const GSV_ACTEX_FLAG_BAUDRATE As Long = &H1&
    Public Structure GSV_ACTIVATE_EXTENDED
        Dim actex_size As Long
        Dim actex_buffersize As Long
        Dim actex_flags As Long
        Dim actex_baudrate As Long
    End Structure

    Public Declare Function GSVversion Lib "MEGSV" Alias "#1" () As Integer
    Public Declare Function GSVmodel Lib "MEGSV" Alias "#2" (ByVal no As Integer) As Integer
    'Public Declare Function MEreservedExec Lib "MEGSV" Alias "#3" (ByVal no As Integer, ByVal code As Integer, ByVal rexpro As Integer, ByRef arg As Any) As Integer
    Public Declare Function MErequestEvent Lib "MEGSV" Alias "#4" (ByVal no As Integer) As Integer
    Public Declare Function GSVgetLocalBaudRate Lib "MEGSV" Alias "#8" (ByVal no As Integer) As Integer
    Public Declare Function GSVactivateExtended Lib "MEGSV" Alias "#9" (ByVal no As Integer, ByRef actex As GSV_ACTIVATE_EXTENDED) As Integer
    Public Declare Function GSVactivate Lib "MEGSV" Alias "#10" (ByVal no As Integer, ByVal buffersize As Integer) As Integer
    Public Declare Sub GSVrelease Lib "MEGSV" Alias "#11" (ByVal no As Integer)
    Public Declare Function GSVinitialize Lib "MEGSV" Alias "#12" (ByVal no As Integer) As Integer
    Public Declare Function GSVflushBuffer Lib "MEGSV" Alias "#13" (ByVal no As Integer) As Integer
    Public Declare Function GSVgetValues Lib "MEGSV" Alias "#17" (ByRef no As Integer, ByVal n As Integer) As Integer
    Public Declare Function MEsendBytesToDevices Lib "MEGSV" Alias "#18" (ByRef no As Integer, ByVal n As Integer, ByRef pbuf As Byte, ByVal count As Integer) As Integer
    Public Declare Function MEsendBytes Lib "MEGSV" Alias "#19" (ByVal no As Integer, ByRef pbuf As Byte, ByVal count As Integer) As Integer
    Public Declare Function GSVreceived Lib "MEGSV" Alias "#20" (ByVal no As Integer) As Integer
    Public Declare Function GSVread Lib "MEGSV" Alias "#21" (ByVal no As Integer, ByRef ad As Double) As Integer
    Public Declare Function GSVreadMultiple Lib "MEGSV" Alias "#22" (ByVal no As Integer, ByRef ad As Double, ByVal count As Integer, ByRef valsread As Integer) As Integer
    'Public Declare Function GSVcopyMemory Lib "MEGSV" Alias "#23" (ByVal no As Integer, ByVal dc As Integer, ByVal addr As Integer, ByRef buffer As Any) As Integer
    Public Declare Function GSVcheckMemory Lib "MEGSV" Alias "#24" (ByVal no As Integer, ByVal dc As Integer, ByVal addr As Integer, ByRef buffer As Byte) As Integer
    Public Declare Function GSVreadStatus Lib "MEGSV" Alias "#25" (ByVal no As Integer, ByRef ad As Double, ByRef ps As Byte) As Integer
    Public Declare Function GSVreadStatusMultiple Lib "MEGSV" Alias "#26" (ByVal no As Integer, ByRef ad As Double, ByRef ps As Byte, ByVal count As Integer, ByRef valsread As Integer) As Integer
    'Public Declare Function MEasynchronousSendBytes Lib "MEGSV" Alias "#28" (ByVal no As Integer, ByRef pbuf As Byte, ByVal count As Integer, ByRef handle As Any) As Integer
    Public Declare Function MEsynchronizeSendBytes Lib "MEGSV" Alias "#29" (ByVal no As Integer) As Integer
    Public Declare Function GSVgetOptionsCode Lib "MEGSV" Alias "#30" (ByVal no As Integer) As Integer
    Public Declare Function GSVgetOptionsExtension3 Lib "MEGSV" Alias "#31" (ByVal no As Integer) As Integer
    Public Declare Function GSVgetOptionsLinear Lib "MEGSV" Alias "#32" (ByVal no As Integer) As Integer
    Public Declare Function GSVgetOptionsExtension21 Lib "MEGSV" Alias "#33" (ByVal no As Integer) As Integer
    Public Declare Function GSVgetOptionsSleepMode Lib "MEGSV" Alias "#34" (ByVal no As Integer) As Integer
    Public Declare Function GSVisBipol Lib "MEGSV" Alias "#50" (ByVal no As Integer) As Integer
    Public Declare Function GSVgetFreq Lib "MEGSV" Alias "#51" (ByVal no As Integer) As Double
    Public Declare Function GSVgetGain Lib "MEGSV" Alias "#52" (ByVal no As Integer) As Integer
    Public Declare Function GSVgetChannel Lib "MEGSV" Alias "#53" (ByVal no As Integer) As Integer
    Public Declare Function MEsetModeLock Lib "MEGSV" Alias "#54" (ByVal no As Integer, ByVal slock As Integer, ByVal id As String) As Integer
    Public Declare Function GSVgetModeLock Lib "MEGSV" Alias "#55" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetModeLinear Lib "MEGSV" Alias "#56" (ByVal no As Integer, ByVal lin As Integer) As Integer
    Public Declare Function GSVgetModeLinear Lib "MEGSV" Alias "#57" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetModeAverage Lib "MEGSV" Alias "#58" (ByVal no As Integer, ByVal avg As Integer) As Integer
    Public Declare Function GSVgetModeAverage Lib "MEGSV" Alias "#59" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetModeSI Lib "MEGSV" Alias "#60" (ByVal no As Integer, ByVal msi As Integer) As Integer
    Public Declare Function GSVgetModeSI Lib "MEGSV" Alias "#61" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetModeText Lib "MEGSV" Alias "#62" (ByVal no As Integer, ByVal mt As Integer) As Integer
    Public Declare Function GSVgetModeText Lib "MEGSV" Alias "#63" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetModeMax Lib "MEGSV" Alias "#64" (ByVal no As Integer, ByVal mx As Integer) As Integer
    Public Declare Function GSVgetModeMax Lib "MEGSV" Alias "#65" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetModeLog Lib "MEGSV" Alias "#66" (ByVal no As Integer, ByVal lg As Integer) As Integer
    Public Declare Function GSVgetModeLog Lib "MEGSV" Alias "#67" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetModeWindow Lib "MEGSV" Alias "#68" (ByVal no As Integer, ByVal win As Integer) As Integer
    Public Declare Function GSVgetModeWindow Lib "MEGSV" Alias "#69" (ByVal no As Integer) As Integer
    Public Declare Function GSVhasLCD Lib "MEGSV" Alias "#70" (ByVal no As Integer) As Integer
    Public Declare Function GSVhasADC Lib "MEGSV" Alias "#71" (ByVal no As Integer) As Integer
    Public Declare Function GSVhasUII Lib "MEGSV" Alias "#72" (ByVal no As Integer) As Integer
    Public Declare Function GSVisSI Lib "MEGSV" Alias "#73" (ByVal no As Integer) As Integer
    Public Declare Function GSVisWL Lib "MEGSV" Alias "#74" (ByVal no As Integer) As Integer
    Public Declare Function GSVhasAF Lib "MEGSV" Alias "#75" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetBridgeType Lib "MEGSV" Alias "#80" (ByVal no As Integer, ByVal bt As Integer) As Integer
    Public Declare Function GSVgetBridgeType Lib "MEGSV" Alias "#81" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetBridgeInternal Lib "MEGSV" Alias "#84" (ByVal no As Integer, ByVal bi As Integer) As Integer
    Public Declare Function GSVgetBridgeInternal Lib "MEGSV" Alias "#85" (ByVal no As Integer) As Integer
    Public Declare Function GSVresetStatus Lib "MEGSV" Alias "#100" (ByVal no As Integer) As Integer
    Public Declare Function GSVgetScale Lib "MEGSV" Alias "#101" (ByVal no As Integer) As Integer
    Public Declare Function GSVgetZero Lib "MEGSV" Alias "#102" (ByVal no As Integer) As Integer
    Public Declare Function GSVgetControl Lib "MEGSV" Alias "#103" (ByVal no As Integer) As Integer
    Public Declare Function GSVgetOffset Lib "MEGSV" Alias "#104" (ByVal no As Integer) As Integer
    Public Declare Function GSVwriteScale Lib "MEGSV" Alias "#105" (ByVal no As Integer, ByVal scalev As Integer) As Integer
    Public Declare Function GSVwriteZero Lib "MEGSV" Alias "#106" (ByVal no As Integer, ByVal zero As Integer) As Integer
    Public Declare Function GSVwriteControl Lib "MEGSV" Alias "#107" (ByVal no As Integer, ByVal control As Integer) As Integer
    Public Declare Function GSVwriteOffset Lib "MEGSV" Alias "#108" (ByVal no As Integer, ByVal offset As Integer) As Integer
    Public Declare Function GSVgetAll Lib "MEGSV" Alias "#109" (ByVal no As Integer, ByVal pos As Integer) As Integer
    Public Declare Function GSVsaveAll Lib "MEGSV" Alias "#110" (ByVal no As Integer, ByVal pos As Integer) As Integer
    Public Declare Function GSVsetCal Lib "MEGSV" Alias "#111" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetZero Lib "MEGSV" Alias "#112" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetScale Lib "MEGSV" Alias "#113" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetOffset Lib "MEGSV" Alias "#114" (ByVal no As Integer) As Integer
    Public Declare Function GSVDispSetUnit Lib "MEGSV" Alias "#115" (ByVal no As Integer, ByVal dispunit As Integer) As Integer
    Public Declare Function GSVDispSetNorm Lib "MEGSV" Alias "#116" (ByVal no As Integer, ByVal norm As Double) As Integer
    Public Declare Function GSVDispSetDPoint Lib "MEGSV" Alias "#117" (ByVal no As Integer, ByVal dpoint As Integer) As Integer
    Public Declare Function GSVsetFreq Lib "MEGSV" Alias "#118" (ByVal no As Integer, ByVal freq As Double) As Integer
    Public Declare Function GSVsetGain Lib "MEGSV" Alias "#119" (ByVal no As Integer, ByVal gain As Integer) As Integer
    Public Declare Function GSVsetBipolar Lib "MEGSV" Alias "#120" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetUnipolar Lib "MEGSV" Alias "#121" (ByVal no As Integer) As Integer
    Public Declare Function MEsetCal Lib "MEGSV" Alias "#123" (ByVal no As Integer, ByVal cal As Double) As Integer
    Public Declare Function MEgetCal Lib "MEGSV" Alias "#124" (ByVal no As Integer) As Double
    Public Declare Function MEsendID Lib "MEGSV" Alias "#125" (ByVal no As Integer, ByVal id As String) As Integer
    Public Declare Function GSVDispGetNorm Lib "MEGSV" Alias "#126" (ByVal no As Integer) As Double
    Public Declare Function GSVDispGetUnit Lib "MEGSV" Alias "#127" (ByVal no As Integer) As Integer
    Public Declare Function GSVDispGetDPoint Lib "MEGSV" Alias "#128" (ByVal no As Integer) As Integer
    Public Declare Function GSVswitch Lib "MEGSV" Alias "#129" (ByVal no As Integer, ByVal swon As Integer) As Integer
    Public Declare Function MEwriteSerialNo Lib "MEGSV" Alias "#130" (ByVal no As Integer, ByVal number As String) As Integer
    Private Declare Function MEreadSerialNo Lib "MEGSV" Alias "#131" (ByVal no As Integer, ByVal number As String) As Integer
    Public Declare Function GSVsetThreshold Lib "MEGSV" Alias "#132" (ByVal no As Integer, ByVal thon As Double, ByVal thoff As Double) As Integer
    Public Declare Function GSVgetThreshold Lib "MEGSV" Alias "#133" (ByVal no As Integer, ByRef thon As Double, ByRef thoff As Double) As Integer
    Public Declare Function GSVsetChannel Lib "MEGSV" Alias "#134" (ByVal no As Integer, ByVal channel As Integer) As Integer
    Public Declare Function GSVstopTransmit Lib "MEGSV" Alias "#135" (ByVal no As Integer) As Integer
    Public Declare Function GSVstartTransmit Lib "MEGSV" Alias "#136" (ByVal no As Integer) As Integer
    Public Declare Function GSVclearBuffer Lib "MEGSV" Alias "#137" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetMode Lib "MEGSV" Alias "#138" (ByVal no As Integer, ByVal mode As Integer) As Integer
    Public Declare Function GSVgetMode Lib "MEGSV" Alias "#139" (ByVal no As Integer) As Integer
    Public Declare Function MEwriteEquipment Lib "MEGSV" Alias "#140" (ByVal no As Integer, ByVal equip As Integer) As Integer
    Public Declare Function GSVgetEquipment Lib "MEGSV" Alias "#141" (ByVal no As Integer) As Integer
    Public Declare Function GSVfirmwareVersion Lib "MEGSV" Alias "#143" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetGageFactor Lib "MEGSV" Alias "#144" (ByVal no As Integer, ByVal gf As Double) As Integer
    Public Declare Function GSVgetGageFactor Lib "MEGSV" Alias "#145" (ByVal no As Integer) As Double
    Public Declare Function GSVsetPoisson Lib "MEGSV" Alias "#146" (ByVal no As Integer, ByVal poiss As Double) As Integer
    Public Declare Function GSVgetPoisson Lib "MEGSV" Alias "#147" (ByVal no As Integer) As Double
    Public Declare Function GSVsetBridge Lib "MEGSV" Alias "#148" (ByVal no As Integer, ByVal br As Integer) As Integer
    Public Declare Function GSVgetBridge Lib "MEGSV" Alias "#149" (ByVal no As Integer) As Integer
    Public Declare Function MEwriteRange Lib "MEGSV" Alias "#150" (ByVal no As Integer, ByVal range As Double) As Integer
    Public Declare Function GSVgetRange Lib "MEGSV" Alias "#151" (ByVal no As Integer) As Double
    Public Declare Function MEsetOffsetWait Lib "MEGSV" Alias "#152" (ByVal no As Integer, ByVal ow As Double) As Integer
    Public Declare Function MEgetOffsetWait Lib "MEGSV" Alias "#153" (ByVal no As Integer) As Double
    Public Declare Function GSVgetOptions Lib "MEGSV" Alias "#154" (ByVal no As Integer) As Integer
    Public Declare Function MEwriteOptions Lib "MEGSV" Alias "#155" (ByVal no As Integer, ByVal options As Integer) As Integer
    'Public Declare Function GSVreadMemory Lib "MEGSV" Alias "#156" (ByVal no As Integer, ByVal addr As Integer, ByRef buffer As Any, ByRef status As Any) As Integer
    'Public Declare Function GSVwriteMemory Lib "MEGSV" Alias "#157" (ByVal no As Integer, ByVal addr As Integer, ByVal check As Integer, ByVal value As Integer, ByRef status As Any) As Integer
    Public Declare Function GSVgetMemoryWait Lib "MEGSV" Alias "#158" (ByVal no As Integer) As Double
    Public Declare Function GSVgetValue Lib "MEGSV" Alias "#159" (ByVal no As Integer) As Integer
    Public Declare Function GSVclearMaxValue Lib "MEGSV" Alias "#160" (ByVal no As Integer) As Integer
    Public Declare Function GSVDispSetDigits Lib "MEGSV" Alias "#161" (ByVal no As Integer, ByVal digits As Integer) As Integer
    Public Declare Function GSVDispGetDigits Lib "MEGSV" Alias "#162" (ByVal no As Integer) As Integer
    Public Declare Function GSVunlockUII Lib "MEGSV" Alias "#163" (ByVal no As Integer) As Integer
    Public Declare Function GSVlockUII Lib "MEGSV" Alias "#164" (ByVal no As Integer) As Integer
    Public Declare Function GSVgetLastError Lib "MEGSV" Alias "#166" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetSecondThreshold Lib "MEGSV" Alias "#167" (ByVal no As Integer, ByVal thon As Double, ByVal thoff As Double) As Integer
    Public Declare Function GSVgetSecondThreshold Lib "MEGSV" Alias "#168" (ByVal no As Integer, ByRef thon As Double, ByRef thoff As Double) As Integer
    Public Declare Function GSVgetDeviceType Lib "MEGSV" Alias "#169" (ByVal no As Integer) As Integer
    Public Declare Function GSVDispCalcNorm Lib "MEGSV" Alias "#170" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetTxMode Lib "MEGSV" Alias "#228" (ByVal no As Integer, ByVal txmode As Integer) As Integer
    Public Declare Function GSVgetTxMode Lib "MEGSV" Alias "#229" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetBaud Lib "MEGSV" Alias "#230" (ByVal no As Integer, ByVal baud As Integer) As Integer
    Public Declare Function GSVgetBaud Lib "MEGSV" Alias "#231" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetSlowRate Lib "MEGSV" Alias "#234" (ByVal no As Integer, ByVal secs As Integer) As Integer
    Public Declare Function GSVgetSlowRate Lib "MEGSV" Alias "#235" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetSpecialMode Lib "MEGSV" Alias "#236" (ByVal no As Integer, ByVal smode As Integer) As Integer
    Public Declare Function GSVgetSpecialMode Lib "MEGSV" Alias "#237" (ByVal no As Integer) As Integer
    Public Declare Function GSVwriteSamplingRate Lib "MEGSV" Alias "#238" (ByVal no As Integer, ByVal freq As Double, ByVal factor As Integer) As Integer
    Public Declare Function GSVreadSamplingRate Lib "MEGSV" Alias "#239" (ByVal no As Integer, ByRef freq As Double, ByRef factor As Integer) As Integer
    Public Declare Function GSVsetCanSetting Lib "MEGSV" Alias "#240" (ByVal no As Integer, ByVal stype As Integer, ByVal val As Integer) As Integer
    Public Declare Function GSVgetCanSetting Lib "MEGSV" Alias "#241" (ByVal no As Integer, ByVal stype As Integer) As Integer
    Public Declare Function GSVsetAnalogFilter Lib "MEGSV" Alias "#244" (ByVal no As Integer, ByVal freq As Double) As Integer
    Public Declare Function GSVgetAnalogFilter Lib "MEGSV" Alias "#245" (ByVal no As Integer) As Double
    Public Declare Function GSVgetTxModeConfig Lib "MEGSV" Alias "#357" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetTxModeTransmit4 Lib "MEGSV" Alias "#358" (ByVal no As Integer, ByVal t4 As Integer) As Integer
    Public Declare Function GSVgetTxModeTransmit4 Lib "MEGSV" Alias "#359" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetTxModeRepeat3 Lib "MEGSV" Alias "#360" (ByVal no As Integer, ByVal r3 As Integer) As Integer
    Public Declare Function GSVgetTxModeRepeat3 Lib "MEGSV" Alias "#361" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetTxModeTransmit5 Lib "MEGSV" Alias "#362" (ByVal no As Integer, ByVal t5 As Integer) As Integer
    Public Declare Function GSVgetTxModeTransmit5 Lib "MEGSV" Alias "#363" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetTxModeReadOnly Lib "MEGSV" Alias "#364" (ByVal no As Integer, ByVal ro As Integer) As Integer
    Public Declare Function GSVgetTxModeReadOnly Lib "MEGSV" Alias "#365" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetSpecialModeSlow Lib "MEGSV" Alias "#372" (ByVal no As Integer, ByVal slow As Integer) As Integer
    Public Declare Function GSVgetSpecialModeSlow Lib "MEGSV" Alias "#373" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetSpecialModeAverage Lib "MEGSV" Alias "#374" (ByVal no As Integer, ByVal avg As Integer) As Integer
    Public Declare Function GSVgetSpecialModeAverage Lib "MEGSV" Alias "#375" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetSpecialModeFilter Lib "MEGSV" Alias "#376" (ByVal no As Integer, ByVal flt As Integer) As Integer
    Public Declare Function GSVgetSpecialModeFilter Lib "MEGSV" Alias "#377" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetSpecialModeMax Lib "MEGSV" Alias "#378" (ByVal no As Integer, ByVal mx As Integer) As Integer
    Public Declare Function GSVgetSpecialModeMax Lib "MEGSV" Alias "#379" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetSpecialModeFilterAuto Lib "MEGSV" Alias "#380" (ByVal no As Integer, ByVal fltauto As Integer) As Integer
    Public Declare Function GSVgetSpecialModeFilterAuto Lib "MEGSV" Alias "#381" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetSpecialModeFilterOrder5 Lib "MEGSV" Alias "#382" (ByVal no As Integer, ByVal fltord5 As Integer) As Integer
    Public Declare Function GSVgetSpecialModeFilterOrder5 Lib "MEGSV" Alias "#383" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetSpecialModeSleep Lib "MEGSV" Alias "#384" (ByVal no As Integer, ByVal sleep As Integer) As Integer
    Public Declare Function GSVgetSpecialModeSleep Lib "MEGSV" Alias "#385" (ByVal no As Integer) As Integer
    Public Declare Function GSVreadSamplingFrequency Lib "MEGSV" Alias "#404" (ByVal no As Integer) As Double
    Public Declare Function GSVreadSamplingFactor Lib "MEGSV" Alias "#405" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetBaudRate Lib "MEGSV" Alias "#406" (ByVal no As Integer, ByVal baud As Integer) As Integer
    Public Declare Function GSVgetBaudRate Lib "MEGSV" Alias "#407" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetCanBaudRate Lib "MEGSV" Alias "#408" (ByVal no As Integer, ByVal baud As Integer) As Integer
    Public Declare Function GSVgetCanBaudRate Lib "MEGSV" Alias "#409" (ByVal no As Integer) As Integer
    Public Declare Function GSVisSamplingFrequencyProtocolLinear Lib "MEGSV" Alias "#410" (ByVal no As Integer) As Integer
    Public Declare Function GSVisSamplingFactorProtocolLinear Lib "MEGSV" Alias "#411" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetCanID Lib "MEGSV" Alias "#412" (ByVal no As Integer, ByVal idtype As Integer, ByVal id As Integer) As Integer
    Public Declare Function GSVgetCanID Lib "MEGSV" Alias "#413" (ByVal no As Integer, ByVal idtype As Integer) As Integer
    Public Declare Function GSVsetCanBaud Lib "MEGSV" Alias "#414" (ByVal no As Integer, ByVal baud As Integer) As Integer
    Public Declare Function GSVgetCanBaud Lib "MEGSV" Alias "#415" (ByVal no As Integer) As Integer
    Public Declare Function GSVisCanAvailable Lib "MEGSV" Alias "#417" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetCanActive Lib "MEGSV" Alias "#418" (ByVal no As Integer, ByVal active As Integer) As Integer
    Public Declare Function GSVgetCanActive Lib "MEGSV" Alias "#419" (ByVal no As Integer) As Integer
    Public Declare Function GSVsetCanMode20B Lib "MEGSV" Alias "#420" (ByVal no As Integer, ByVal mode20b As Integer) As Integer
    Public Declare Function GSVgetCanMode20B Lib "MEGSV" Alias "#421" (ByVal no As Integer) As Integer
    'Public Function GSV_ACTEX_SIZE() As Integer
End Class